import tkinter
import random

# konštanty špecifikujúce parametre generovaného obrazu
SIRKA_PLATNA = 500
VYSKA_PLATNA = 500

VELKOST_STVORCA = 10

MAX_CIAR = 10
MIN_CIAR = 6
MAX_OBDLZNIKOV = 10
MIN_OBDLZNIKOV = 3

POCET_RIADKOV = VYSKA_PLATNA // VELKOST_STVORCA
POCET_STLPCOV = SIRKA_PLATNA // VELKOST_STVORCA

FARBY = ['red', 'yellow', 'blue']


def ciary():
    pocet = random.randint(MIN_CIAR, MAX_CIAR)

    for h in range(pocet // 2):
        r = random.randrange(POCET_RIADKOV)
        for s in range(POCET_STLPCOV):
            platno.itemconfig(obraz[r][s], fill='black')

    for v in range(pocet // 2):
        s = random.randrange(POCET_STLPCOV)
        for r in range(POCET_RIADKOV):
            platno.itemconfig(obraz[r][s], fill='black')


def mriezka():
    for r in range(POCET_RIADKOV):
        for s in range(POCET_STLPCOV):
            obraz[r][s] = platno.create_rectangle(s * VELKOST_STVORCA, r * VELKOST_STVORCA, (s + 1) * VELKOST_STVORCA,
                                                  (r + 1) * (VELKOST_STVORCA), fill='white', outline='')


# hlavný program
# príprava grafického plátna
platno = tkinter.Canvas(width=SIRKA_PLATNA, height=VYSKA_PLATNA, bg='white')

# vytvorenie zoznamu zoznamov pre pamätanie si štvorcov siete
obraz = [[0] * POCET_STLPCOV for i in range(POCET_RIADKOV)]

# vykreslenie štvorcov na plátne
mriezka()
ciary()

# zobrazenie aplikácie s plátnom
platno.pack()
platno.mainloop()
